<?php

namespace Simply_Static\Backup\ThirdParty\servmask\backup;

use Simply_Static\Backup\Backup;
use Simply_Static\Backup\Status;

if ( ! defined( 'ABSPATH' ) ) {
	die( 'Kangaroos cannot jump here' );
}

class Backup_Archive {

	public static function execute( $params = [] ) {

		do_action( 'sssbm_status_export_start', $params );

		// Set progress
		Status::info( __( 'Creating backup file...', 'sss-backup-migrate' ), 'ssse-export-init' );

		if ( file_exists( Backup::get_backup_path() ) ) {
			@unlink( Backup::get_backup_path() );
		}

		// Create empty archive file
		$archive = new \ZipArchive();
		$archive->open( Backup::get_backup_path(), \ZipArchive::CREATE | \ZipArchive::OVERWRITE );
		$archive->close();

		// Set progress
		Status::success( __( 'Backup file created.', 'sss-backup-migrate' ), 'ssse-export-init' );

		return $params;
	}
}
