<?php

namespace Simply_Static\Backup\ThirdParty\servmask\backup;

use Simply_Static\Backup\Backup;
use Simply_Static\Backup\Helper;
use Simply_Static\Backup\Status;

if ( ! defined( 'ABSPATH' ) ) {
	die( 'Kangaroos cannot jump here' );
}

class Backup_Database_File {

	public static function execute( $params = [] ) {

		// Set exclude database
		if ( isset( $params['options']['no_database'] ) ) {
			return $params;
		}

		$database_bytes_written = 0;

		// Set archive bytes offset
		if ( isset( $params['archive_bytes_offset'] ) ) {
			$archive_bytes_offset = (int) $params['archive_bytes_offset'];
		} else {
			$archive_bytes_offset = Helper::getArchiveBytes();
		}

		// Set database bytes offset
		if ( isset( $params['database_bytes_offset'] ) ) {
			$database_bytes_offset = (int) $params['database_bytes_offset'];
		} else {
			$database_bytes_offset = 0;
		}

		// Get total database size
		if ( isset( $params['total_database_size'] ) ) {
			$total_database_size = (int) $params['total_database_size'];
		} else {
			$total_database_size = filesize( Backup::get_database_path() );
		}

		// What percent of database have we processed?
		$progress = (int) min( ( $database_bytes_offset / $total_database_size ) * 100, 100 );

		// Set progress
		/* translators: Progress. */
		Status::info( sprintf( __( 'Backing up database...<br />%d%% complete', 'sss-backup-migrate' ), $progress ), 'ssse-database-file' );

		// Open the archive file for writing
		//$archive = new Compressor( ai1wm_archive_path( $params ) );
		$archive = new \ZipArchive();
		$archive->open( Backup::get_backup_path(), \ZipArchive::CREATE );

		// Set the file pointer to the one that we have saved
		//$archive->set_file_pointer( $archive_bytes_offset );

		// Add database.sql to archive
		if ( $archive->addFile( Backup::get_database_path(), 'db.sql' ) ) {

			// Set progress
			Status::success( __( 'Database backed up.', 'sss-backup-migrate' ), 'ssse-database-file' );

			$params['completed'] = true;

		} else {

			// Get archive bytes offset
			$archive_bytes_offset = filesize( Backup::get_backup_path() );

			// What percent of database have we processed?
			$progress = (int) min( ( $database_bytes_offset / $total_database_size ) * 100, 100 );

			// Set progress
			/* translators: Progress. */
			Status::info( sprintf( __( 'Backing up database...<br />%d%% complete', 'sss-backup-migrate' ), $progress ), 'ssse-database-file' );;

			// Set archive bytes offset
			$params['archive_bytes_offset'] = $archive_bytes_offset;

			// Set database bytes offset
			$params['database_bytes_offset'] = $database_bytes_offset;

			// Set total database size
			$params['total_database_size'] = $total_database_size;

			// Set completed flag
			$params['completed'] = false;
		}

		// Truncate the archive file
		//$archive->truncate();

		// Close the archive file
		$archive->close();

		return $params;
	}
}
