<?php

namespace Simply_Static\Backup\ThirdParty\servmask\filter;

if ( ! defined( 'ABSPATH' ) ) {
	die( 'Kangaroos cannot jump here' );
}

class Recursive_Exclude_Filter extends \RecursiveFilterIterator {

	protected $exclude = array();

	protected function replace_slash_with_separator( $path ) {
		return str_replace( '/', DIRECTORY_SEPARATOR, $path );
	}

	public function __construct( \RecursiveIterator $iterator, $exclude = array() ) {
		parent::__construct( $iterator );
		if ( is_array( $exclude ) ) {
			foreach ( $exclude as $path ) {
				$this->exclude[] = $this->replace_slash_with_separator( $path );
			}
		}
	}

	#[\ReturnTypeWillChange]
	public function accept() {
		// Honor explicit excludes passed in
		if ( in_array( $this->replace_slash_with_separator( $this->getInnerIterator()->getSubPathname() ), $this->exclude ) ) {
			return false;
		}

		if ( in_array( $this->replace_slash_with_separator( $this->getInnerIterator()->getPathname() ), $this->exclude ) ) {
			return false;
		}

		if ( in_array( $this->replace_slash_with_separator( $this->getInnerIterator()->getPath() ), $this->exclude ) ) {
			return false;
		}

		// Safety: skip invalid subpathnames
		if ( strpos( $this->getInnerIterator()->getSubPathname(), "\n" ) !== false ) {
			return false;
		}

		if ( strpos( $this->getInnerIterator()->getSubPathname(), "\r" ) !== false ) {
			return false;
		}

		// Automatically exclude node_modules directories and common archive files
		$sub = $this->getInnerIterator()->getSubPathname();
		$path = $this->getInnerIterator()->getPathname();

		$ds = DIRECTORY_SEPARATOR;

		// Exclude any path that is or is within a node_modules directory
		if (
			strpos( $sub, 'node_modules' . $ds ) !== false ||
			strpos( $path, $ds . 'node_modules' . $ds ) !== false ||
			basename( $path ) === 'node_modules'
		) {
			return false;
		}

		// Exclude archive files: .zip, .tar, .tar.gz, .tgz
		$lowerSub = strtolower( $sub );
		$lowerPath = strtolower( $path );
		if (
			preg_match( '/\.zip$/', $lowerSub ) || preg_match( '/\.zip$/', $lowerPath ) ||
			preg_match( '/\.tar$/', $lowerSub ) || preg_match( '/\.tar$/', $lowerPath ) ||
			preg_match( '/\.tar\.gz$/', $lowerSub ) || preg_match( '/\.tar\.gz$/', $lowerPath ) ||
			preg_match( '/\.tgz$/', $lowerSub ) || preg_match( '/\.tgz$/', $lowerPath )
		) {
			return false;
		}

		return true;
	}

	#[\ReturnTypeWillChange]
	public function getChildren() {
		return new self( $this->getInnerIterator()->getChildren(), $this->exclude );
	}
}
