<?php

namespace Simply_Static\Backup;

use Simply_Static\Backup\Queue\Backup_Process;
use Simply_Static\Backup\Rest\Settings;

class Plugin {

	public function __construct() {
		new Backup_Process();

		Settings::get_instance();

		add_action( 'admin_menu', [ $this, 'admin_menu' ] );

	}

	/**
	 * Register Admin menu page
	 *
	 * @return void
	 */
	public function admin_menu() {

		$menu_hook = add_submenu_page(
			'tools.php',
			__( 'Backup and Migrate', 'sss-backup-migrate' ),
			__( 'Backup and Migrate', 'sss-backup-migrate' ),
			'manage_options',
			'studio-backup',
			array( $this, 'render_menu_page' ),
			0 // menu position
		);

		add_action( "admin_print_scripts-{$menu_hook}", array( $this, 'add_settings_scripts' ) );
	}

	public function add_settings_scripts() {
		wp_enqueue_script( 'simply-static-backup-migrate-settings', SSSBM_URL . '/src/Admin/build/index.js', array(
			'wp-api',
			'wp-components',
			'wp-element',
			'wp-api-fetch',
			'wp-data',
			'wp-i18n',
			'wp-block-editor'
		), SSSBM_VERSION, true );

		wp_localize_script( 'simply-static-backup-migrate-settings', 'sss_backup_migrate_options', [ 'blog_id' => get_current_blog_id() ] );
		wp_enqueue_style( 'simply-static-backup-migrate-settings-style', SSSBM_URL . '/src/Admin/build/index.css', array( 'wp-components' ) );
	}


	/**
	 * Render Menu page.
	 * @return void
	 */
	public function render_menu_page() {
		?>
        <div id="static-studio-backup"></div>
        <script type="text/javascript">
            jQuery(document).ready(function ($) {
                $('#wpcontent').height($('#wpwrap').height());
            });
        </script>
		<?php
	}


}